#!/bin/bash

# Download Fonts Script for Zen Zone Spa
# This script downloads all required font files locally

echo "🚀 Downloading fonts for Zen Zone Spa..."

# Create directories
echo "📁 Creating directories..."
mkdir -p backend/backend-docs-assets/fonts/poppins
mkdir -p backend/backend-docs-assets/fonts/remixicon

# Download Poppins fonts
echo "📥 Downloading Poppins fonts..."
cd backend/backend-docs-assets/fonts/poppins

# Poppins 300 (Light)
echo "  - Poppins 300 (Light)"
wget -q -O poppins-v20-latin-300.woff2 "https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLEj6Z1xlFd2JQEk.woff2"
wget -q -O poppins-v20-latin-300.woff "https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLEj6Z11lFQ.woff"

# Poppins 400 (Regular)
echo "  - Poppins 400 (Regular)"
wget -q -O poppins-v20-latin-regular.woff2 "https://fonts.gstatic.com/s/poppins/v20/pxiEyp8kv8JHgFVrJJfecnFHGPc.woff2"
wget -q -O poppins-v20-latin-regular.woff "https://fonts.gstatic.com/s/poppins/v20/pxiEyp8kv8JHgFVrJJnecg.woff"

# Poppins 500 (Medium)
echo "  - Poppins 500 (Medium)"
wget -q -O poppins-v20-latin-500.woff2 "https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLGT9Z1xlFd2JQEk.woff2"
wget -q -O poppins-v20-latin-500.woff "https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLGT9Z11lFQ.woff"

# Poppins 600 (Semi Bold)
echo "  - Poppins 600 (Semi Bold)"
wget -q -O poppins-v20-latin-600.woff2 "https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLEj6Z1xlFd2JQEk.woff2"
wget -q -O poppins-v20-latin-600.woff "https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLEj6Z11lFQ.woff"

# Poppins 700 (Bold)
echo "  - Poppins 700 (Bold)"
wget -q -O poppins-v20-latin-700.woff2 "https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLCz7Z1xlFd2JQEk.woff2"
wget -q -O poppins-v20-latin-700.woff "https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLCz7Z11lFQ.woff"

# Download Remix Icons
echo "📥 Downloading Remix Icons..."
cd ../remixicon

echo "  - Remix Icons WOFF2"
wget -q -O remixicon.woff2 "https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.woff2"

echo "  - Remix Icons WOFF"
wget -q -O remixicon.woff "https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.woff"

echo "  - Remix Icons TTF"
wget -q -O remixicon.ttf "https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.ttf"

# Go back to project root
cd ../../../../

echo ""
echo "✅ Font download completed!"
echo ""
echo "📋 Next steps:"
echo "1. Upload all files to your cPanel server"
echo "2. Verify the fonts.css file is loaded in docs.html"
echo "3. Test your site at https://zenzone.rw/backend/docs.html"
echo ""
echo "🎯 Benefits:"
echo "✅ No more CSP errors"
echo "✅ Faster loading (no external DNS)"
echo "✅ Better privacy (no tracking)"
echo "✅ Offline support"
echo ""
echo "📁 Files downloaded to:"
echo "   backend/backend-docs-assets/fonts/poppins/ (10 files)"
echo "   backend/backend-docs-assets/fonts/remixicon/ (3 files)" 