-- =====================================================
-- Cleanup Test Users - Keep Only Admin and Therapist1
-- =====================================================

-- Step 1: Check what we're about to delete
SELECT 'Users to be deleted:' as info;
SELECT id, username, email, role 
FROM users 
WHERE id NOT IN (1, 11);

-- Step 2: Delete test users (keep only admin and therapist1)
DELETE FROM users 
WHERE id NOT IN (1, 11);

-- Step 3: Reset auto_increment to clean sequence
ALTER TABLE users AUTO_INCREMENT = 12;

-- Step 4: Verify remaining users
SELECT 'Remaining users:' as info;
SELECT id, username, email, name, role, phone, is_active 
FROM users 
ORDER BY id;

-- Step 5: Update therapist1 name to match the actual therapist record
-- (Optional - to keep consistency)
UPDATE users 
SET name = 'Justine Niwemukobwa' 
WHERE id = 11;

-- Step 6: Verify therapists table
SELECT 'Therapists:' as info;
SELECT id, user_id, name, email, phone, is_active 
FROM therapists 
ORDER BY id;

-- =====================================================
-- Cleanup Complete
-- =====================================================
-- Remaining users:
--   1. admin (admin role)
--   11. therapist1 (therapist role) - linked to therapist id=1
-- 
-- Remaining therapists:
--   1. Justine Niwemukobwa (linked to user_id=11)
--   2. Liliane Uwimana (no user account)
-- =====================================================

