-- =====================================================
-- Fix Therapist1 User - Sync with Actual Therapist Data
-- =====================================================

-- Update therapist1 user to match the actual therapist record
UPDATE users 
SET 
    name = 'Justine Niwemukobwa',
    email = 'justine@zenzone.rw',
    phone = '+250788123456'
WHERE id = 11;

-- Verify the update
SELECT 'Updated therapist1 user:' as info;
SELECT id, username, email, name, role, phone, is_active 
FROM users 
WHERE id = 11;

-- Verify link to therapist record
SELECT 'Linked therapist record:' as info;
SELECT t.id, t.name, t.email, t.phone, t.user_id, u.username, u.role
FROM therapists t
LEFT JOIN users u ON t.user_id = u.id
WHERE t.id = 1;

-- =====================================================
-- Configuration Complete
-- =====================================================
-- Therapist1 Login Credentials:
--   Username: therapist1
--   Password: therapist123
--   Role: therapist
--   Name: Justine Niwemukobwa
--   Email: justine@zenzone.rw
--   Phone: +250788123456
--   Linked to therapist_id: 1
-- =====================================================

